unit AOBufferMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DlsrLib_TLB, OleCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    SRAO: TDriverLINXSR;
    LDD: TDriverLINXLDD;
    cmdInit: TButton;
    cmdStart: TButton;
    lblStatus: TLabel;
    Label2: TLabel;
    procedure cmdInitClick(Sender: TObject);
    procedure cmdStartClick(Sender: TObject);
    procedure ServiceDone(Sender: TObject; var task, device, subsystem,
      mode: Smallint);
    procedure CloseDriver(Sender: TObject);
  private
    { Private declarations }
    AOdata : OleVariant;  // buffer for the data
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.cmdInitClick(Sender: TObject);
begin
// give the LDD control the driver name
ldd.Req_DLL_name := 'kdda816';
ldd.device := 0;  // set your device number here
// fill in driver name above with your driver name
// 'kpci3108' for KPCI-3107 or KPCI-3108 boards
// 'kpci3100' for KPCI-3110 or KPCI-3116
// 'kpci1800' for KPCI-1800HC series boards
// 'kpcaiao' for KPCMCIA multifunction cards
// 'kmb1800' for DAS-1800 series
srao.Req_DLL_name := ldd.Req_DLL_name;
srao.Req_device := ldd.device;
// use LDD control to display full model name
ldd.Refresh;  // get current data for the driver/device
Form1.Caption := 'Buffered Analog Output with ' + ldd.Dev_Model;

// initialize the hardware
  SRAO.Req_subsystem := DL_Device;  // entire device needs Initialized
  SRAO.Req_mode := DL_OTHER;
  SRAO.Req_op := DL_Initialize;
  SRAO.Refresh;
  lblStatus.Caption := SRAO.Message;  // display result

  form1.SetFocus;
end;

procedure TForm1.cmdStartClick(Sender: TObject);
var
i : integer;
dummy : Double;
begin
SRAO.Req_op := DL_Start;
SRAO.Req_subsystem := DL_AO;
SRAO.Req_mode := DL_Interrupt;

SRAO.Evt_Tim_type:= DL_RateEvent;
SRAO.Evt_Tim_rateChannel := DL_DefaultTimer;
SRAO.Evt_Tim_rateMode := DL_RateGen;
SRAO.Evt_Tim_rateClock := DL_INTERNAL1;
SRAO.Evt_Tim_ratePeriod := SRAO.DLSecs2Tics(DL_DefaultTimer, 1/100);
// provide rate to DriverLINX for internal buffering
SRAO.Evt_Tim_rateGate := DL_NOCONNECT;


SRAO.Evt_Str_type := DL_Command;
SRAO.Evt_Stp_type := DL_TCEvent;

SRAO.Sel_chan_N := 1;  // one channel only
SRAO.Sel_chan_start := 0;
SRAO.Sel_chan_startGainCode := SRAO.DLGain2Code(-1);
// use bipolar 10VDC output range

// single channel so do not need stop channel and gain
//SRAO.Sel_chan_stop := 0;
//SRAO.Sel_chan_stopGainCode := 0;
srAO.Sel_buf_N := 1;
SRAO.Sel_buf_samples := 100;
SRAO.Sel_buf_notify := DL_Notify;
SRAO.Sel_chan_format := DL_tNative;
// for AO subsystem, need to load the buffer with data
// before starting the operation

AOdata := VarArrayCreate([0,100],VarSingle); // allocate the array
// load AOdata array with voltage data
for i := 0 to 99
do begin
  AOdata[i] := sin(2*3.14/(i+1));
end;
// use the Convert method to move it from an array to the buffer
// it also converts the volts to DAC counts scaled for the range
// of the channel
dummy := SRAO.ArrayBufferConvert(0,0,100,AOdata,DL_tSINGLE,0,0);
// now just need to issue SRAO.Refresh to start it

//SRAO.Req_op_edit := True;
//SRAO.Refresh;
SRAO.Refresh;     //start the AO
lblStatus.Caption := 'Started AO with ' + SRAO.Message;
end;

procedure TForm1.ServiceDone(Sender: TObject; var task, device, subsystem,
  mode: Smallint);
begin
     lblStatus.Caption := 'Analog Output buffer has been written';
end;

procedure TForm1.CloseDriver(Sender: TObject);
begin
// unload the driver for each object
SRAO.Req_DLL_name := '';
LDD.Req_DLL_name := '';
end;

end.
